import 'package:lottie/lottie.dart';
import 'package:mighty_school/common/global_widget/logo_section.dart';
import 'package:mighty_school/common/widget/side_menu/easy_sidemenu.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/side_sheet_widget.dart';
import 'package:mighty_school/feature/administrator/system_settings/controller/system_settngs_controller.dart';
import 'package:mighty_school/feature/home/widget/subscription_widget.dart';
import 'package:mighty_school/feature/profile/domain/model/profile_model.dart';
import 'package:mighty_school/feature/profile/logic/profile_controller.dart';
import 'package:mighty_school/feature/sidebar/controller/side_menu_bar_controller.dart';
import 'package:mighty_school/feature/user_manual/presentation/user_manual_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/images.dart';
import 'package:mighty_school/util/styles.dart';


class GlobalSideMenu extends StatefulWidget {
  final Widget child;
  const GlobalSideMenu({required this.child, super.key});

  @override
  State<GlobalSideMenu> createState() => _GlobalSideMenuState();
}

class _GlobalSideMenuState extends State<GlobalSideMenu> {
  SideMenuController sideMenu = SideMenuController();
  @override
  Widget build(BuildContext context) {
    return GetBuilder<SideMenuBarController>(
      builder: (sideMenuController) {
        return GetBuilder<SystemSettingsController>(
          builder: (systemSettingsController) {
            Color sidebarColor = systemSettingsController.sidebarColor;
            Color textColor = systemSettingsController.sidebarTextColor;
            return Row(children: [
              GetBuilder<ProfileController>(
                builder: (profileController) {
                  ProfileModel? profileModel = profileController.profileModel;
                  return  ResponsiveHelper.isDesktop(context)?
                  SideMenu(
                      controller: sideMenuController.sideMenu,
                      style: SideMenuStyle(
                          itemOuterPadding: EdgeInsets.zero,
                          itemBorderRadius: BorderRadius.zero,
                          openSideMenuWidth: sideMenuController.isExpanded ? 265 : 0,
                          selectedTitleTextStyleExpandable: textRegular.copyWith(color: Colors.white, fontSize: Dimensions.fontSizeDefault),
                          selectedIconColorExpandable: Theme.of(context).primaryColor,
                          unselectedIconColorExpandable: Colors.white70,
                          displayMode: SideMenuDisplayMode.auto,
                          toggleColor: Colors.white70,
                          arrowCollapse: Theme.of(context).cardColor,
                          arrowOpen: Theme.of(context).cardColor,
                          hoverColor: Theme.of(context).colorScheme.secondary,
                          selectedColor: Theme.of(context).primaryColor,
                          selectedTitleTextStyle: textRegular.copyWith(color: Colors.white, fontSize: Dimensions.fontSizeSmall),
                          selectedIconColor: Theme.of(context).textTheme.displayLarge?.color,
                          unselectedIconColor: Colors.white70,
                          unselectedTitleTextStyle: textRegular.copyWith(color: textColor, fontSize: Dimensions.fontSizeSmall),
                          showHamburger: false,

                          backgroundColor: sidebarColor),
                      title: const LogoSection(),
                      footer: Column(mainAxisSize: MainAxisSize.min, children: [

                        InkWell(onTap: () {
                          showModalSideSheet(Get.context!,
                              barrierDismissible: true,
                              addBackIconButton: false,
                              addActions: false,
                              addDivider: false,
                              body: const Padding(padding: EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
                                  child: UserManualWidget()),
                              header: "user_manual".tr);
                        },
                          child: Container(height: 70, decoration: BoxDecoration(color: Theme.of(context).cardColor),
                              child: Row(spacing: Dimensions.paddingSizeDefault, mainAxisAlignment: MainAxisAlignment.center,children: [
                                Text("user_manual".tr, style: textRegular.copyWith(color: Theme.of(context).textTheme.displayLarge?.color, fontSize: Dimensions.fontSizeLarge),),
                                Lottie.asset(Images.userManual)],
                              )),
                        ),

                        profileModel?.data?.role == "Super Admin"?
                        const SubscriptionWidget():const SizedBox()
                      ],),
                      items: sideMenuController.sideMenuItems):const SizedBox();
                }
              ),
                Expanded(child: widget.child),
              ],
            );
          }
        );
      },
    );
  }
}