import 'package:flutter/material.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/administrator/system_settings/controller/system_settngs_controller.dart';
import 'package:mighty_school/feature/administrator/system_settings/domain/model/general_settings_model.dart';
import 'package:mighty_school/helper/route_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:get/get.dart';

class LogoSection extends StatelessWidget {
  const LogoSection({super.key});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SystemSettingsController>(
      builder: (systemSettingsController) {
        GeneralSettingModel? generalSettingModel = systemSettingsController.generalSettingModel;
        return Center(child: InkWell(onTap: () => Get.toNamed(RouteHelper.getDashboardRoute()),
          child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
            child:
                CustomImage(width: 150,image: "${AppConstants.baseUrl}/public/uploads/logos/${generalSettingModel?.data?.logo}",),
          ),
        ),
        );
      }
    );
  }
}
