import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:url_launcher/url_launcher.dart';

class ImageDialog extends StatelessWidget {
  final String imageUrl;
  const ImageDialog({super.key, required this.imageUrl});

  @override
  Widget build(BuildContext context) {
    return Dialog(
      shape: const RoundedRectangleBorder(borderRadius: BorderRadius.all(Radius.circular(10.0))),
      child: Column(mainAxisSize: MainAxisSize.min, children: [

        Stack(children: [
          CustomImage(image: imageUrl),
          Align(alignment: Alignment.centerRight,
              child: IconButton(icon: Icon(Icons.cancel, color: Theme.of(context).hintColor,),
                  onPressed: () => Navigator.of(context).pop())),

          Align(alignment: Alignment.topLeft,
              child: IconButton(icon: Icon(Icons.download, color: Theme.of(context).hintColor,),
                  onPressed: () async {
                    await launchUrl(Uri.parse(imageUrl));
                    Get.back();
                  })),

        ],
        ),

      ],
      ),
    );
  }
}
