class EventBody {
  String? startDate;
  String? endDate;
  String? name;
  String? details;
  String? location;

  EventBody(
      {this.startDate, this.endDate, this.name, this.details, this.location});

  EventBody.fromJson(Map<String, dynamic> json) {
    startDate = json['start_date'];
    endDate = json['end_date'];
    name = json['name'];
    details = json['details'];
    location = json['location'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['start_date'] = startDate;
    data['end_date'] = endDate;
    data['name'] = name;
    data['details'] = details;
    data['location'] = location;
    return data;
  }
}
