import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/feature/administrator/event/domain/models/event_body.dart';
import 'package:mighty_school/util/app_constants.dart';

class EventRepository{
  final ApiClient apiClient;
  EventRepository({required this.apiClient});


  Future<Response?> getEventList(int page) async {
    return await apiClient.getData("${AppConstants.events}?page=$page&perPage=10");
  }

  Future<Response?> createNewEvent( EventBody eventBody) async {
    return await apiClient.postData(AppConstants.events, eventBody.toJson());
  }

  Future<Response?> updateEvent(EventBody eventBody, int id) async {
    return await apiClient.putData("${AppConstants.events}/$id", eventBody.toJson());
  }
  

  Future<Response?> deleteEvent (int id) async {
    return await apiClient.deleteData("${AppConstants.events}/$id");
  }
}