import 'package:flutter/material.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/feature/administrator/notice/domain/models/user_log_model.dart';
import 'package:mighty_school/helper/date_converter.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class UserLogItemWidget extends StatelessWidget {
  final UserLogItem? userLogItem;
  const UserLogItemWidget({super.key, this.userLogItem});

  @override
  Widget build(BuildContext context) {
    return Column(spacing: Dimensions.paddingSizeExtraSmall,
      children: [
        Row(crossAxisAlignment: CrossAxisAlignment.start, spacing: Dimensions.paddingSizeSmall, children: [
          ClipRRect(borderRadius : BorderRadius.circular(5),child:const CustomImage(width: 40,height: 40,)),
          Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
              Text(userLogItem?.user?.name??'', style: textRegular),
              Text(userLogItem?.detail??'', maxLines: 2,overflow: TextOverflow.ellipsis, style: textRegular),
              Text(DateConverter.dateTimeIs(DateTime.parse(userLogItem!.updatedAt!)),
                  style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall, color: Theme.of(context).hintColor))
            ]),
          ),
        ],
        ),
        const CustomDivider()
      ],
    );
  }
}
