import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/no_data_found.dart';
import 'package:mighty_school/feature/administrator/notice/controller/notice_controller.dart';
import 'package:mighty_school/feature/administrator/notice/domain/models/user_log_model.dart';
import 'package:mighty_school/feature/administrator/notice/presentation/widgets/user_log_item_widget.dart';
import 'package:mighty_school/util/styles.dart';

class UserLogWidget extends StatelessWidget {
  final bool isDashboard;
  final ScrollController scrollController;
  const UserLogWidget({super.key, required this.scrollController, this.isDashboard = false});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<NoticeController>(
      initState: (val){
        if(Get.find<NoticeController>().userLogModel == null){
          Get.find<NoticeController>().getUserLogList(1);
        }
      },
      builder: (userLogController) {
        UserLogModel? userLogModel = userLogController.userLogModel;
        var userLog = userLogModel?.data;
        
        return userLogModel != null ?(userLog != null && userLog.data!.isNotEmpty)?
        ListView.builder(
            itemCount:( userLog.data?.length ?? 0) > 5 ? 5 : userLog.data?.length,
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: const NeverScrollableScrollPhysics(),
            itemBuilder: (context, index){
              return UserLogItemWidget( userLogItem:userLog.data?[index]);
            }): const Padding(padding: EdgeInsets.symmetric(vertical: 100),
              child: NoDataFound(),
            ): Padding(padding: ThemeShadow.getPadding(),
          child: const Center(child: CircularProgressIndicator()),
        );
      }
    );
  }
}
