class AboutUsBody {
  String? title;
  String? heading;
  String? description;
  String? position;
  String? method;

  AboutUsBody({this.title, this.heading, this.description, this.position, this.method});

  AboutUsBody.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    heading = json['heading'];
    description = json['description'].cast<String>();
    position = json['position'];
    method = json['_method'];
  }

  Map<String, String> toJson() {
    final Map<String, String> data = <String, String>{};
    data['title'] = title??'';
    data['heading'] = heading??'';
    data['description'] = description??'';
    data['position'] = position??'';
    data['_method'] = method??'';
    return data;
  }
}
