import 'package:flutter_image_compress/flutter_image_compress.dart';
import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/util/app_constants.dart';

class BenefitRepository {
  final ApiClient apiClient;

  BenefitRepository({required this.apiClient});
  
  Future<Response?> getBenefit(int page) async {
    return await apiClient.getData("${AppConstants.benefits}?page=$page");
  }

  Future<Response?> createBenefit(String title, String description, XFile? file) async {
    return await apiClient.postMultipartData(AppConstants.benefits,{
      "title": title,
      "description": description,
    },[], MultipartBody("image", file), []);
  }

  Future<Response?> editBenefit(String title, String description, XFile? file, int id) async {
    return await apiClient.postMultipartData("$AppConstants.benefits/$id",
        {
          "title": title,
          "description": description,
        },
        [], MultipartBody("image", file), []);
  }



  Future<Response?> deleteBenefit(int id) async {
    return await apiClient.deleteData("${AppConstants.benefits}/$id");
  }
}
  