import 'package:get/get.dart';
import 'package:image_picker/image_picker.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/feature/cms_management/benifit/domain/model/benifit_model.dart';
import 'package:mighty_school/feature/cms_management/benifit/domain/repository/benifit_repository.dart';
import 'package:mighty_school/helper/image_size_checker.dart';

class BenefitController extends GetxController implements GetxService {
  final BenefitRepository benefitRepository;
  BenefitController({required this.benefitRepository});

  BenefitModel? benefitModel;
  Future<void> getBenefit(int page) async {
    Response? response = await benefitRepository.getBenefit(page);
    if (response?.statusCode == 200) {
      if(page == 1) {
        benefitModel = BenefitModel.fromJson(response?.body);
      } else {
        benefitModel?.data?.data?.addAll(BenefitModel.fromJson(response?.body).data?.data ?? []);
        benefitModel?.data?.total = BenefitModel.fromJson(response?.body).data?.total;
        benefitModel?.data?.currentPage = BenefitModel.fromJson(response?.body).data?.currentPage;
      }

    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  XFile? benefitImage;
  XFile? pickedImage;
  void pickImage({bool parentIdProof = false}) async {
    pickedImage = await ImagePicker().pickImage(source: ImageSource.gallery);
    double imageSizeIs = await ImageSize.getImageSize(pickedImage!);
    if(imageSizeIs > 1){
      showCustomSnackBar("please_choose_image_size_less_than_2_mb".tr);
    }else{
      benefitImage = pickedImage;
    }
    update();
  }
  bool loading = false;
  Future<void> createBenefit(String title, String description) async {
    loading = true;
    update();
    Response? response = await benefitRepository.createBenefit(title, description, benefitImage);
    if (response?.statusCode == 200) {
      loading = false;
      Get.back();
      showCustomSnackBar("added_successfully".tr, isError: false);
      getBenefit(1);
    } else {
      loading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }
  Future<void> editBenefit(String title, String description, int id) async {
    loading = true;
    update();
    Response? response = await benefitRepository.editBenefit(title, description, benefitImage, id);
    if (response?.statusCode == 200) {
      loading = false;
      Get.back();
      showCustomSnackBar("updated_successfully".tr, isError: false);
      getBenefit(1);
    } else {
      loading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> deleteBenefit(int id) async {
    Response? response = await benefitRepository.deleteBenefit(id);
    if (response?.statusCode == 200) {
      showCustomSnackBar("deleted_successfully".tr, isError: false);
      getBenefit(1);
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }
}
  