import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/cms_management/benifit/domain/model/benifit_model.dart';
import 'package:mighty_school/feature/cms_management/benifit/logic/benifit_controller.dart';
import 'package:mighty_school/feature/cms_management/benifit/presentation/widgets/create_new_benefit_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class BenefitItemWidget extends StatelessWidget {
  final BenefitItem? benefitItem;
  final int index;
  const BenefitItemWidget({super.key, this.benefitItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.symmetric(vertical: 5),
      child: ResponsiveHelper.isDesktop(context)?
      Column(children: [
        Row(crossAxisAlignment: CrossAxisAlignment.start, spacing: Dimensions.paddingSizeSmall, children: [
          Text('${index+1}. ', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          const SizedBox(width: 120, child: CustomImage(image: "", width: 120,height: 60, radius: 5)),
          Expanded(child: Text("${benefitItem?.title}", maxLines: 1,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Text(benefitItem?.description??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          EditDeleteSection(onEdit: (){
            Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
                child: SizedBox(width: ResponsiveHelper.isDesktop(context)? 600 : Get.width,
                  child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
                    child: CreateNewBenefitWidget(benefitItem: benefitItem,),
                  ),
                )));
          }, onDelete: (){
            Get.dialog(ConfirmationDialog(
                title: "benefit",
                content: "are_you_sure_to_delete_this_benefit".tr,
                onTap: (){
                  Get.back();
                  Get.find<BenefitController>().deleteBenefit(benefitItem?.id??0);
                }));
          }, horizontal: true)
        ]),
        const Padding(padding: EdgeInsets.symmetric(vertical:Dimensions.paddingSizeExtraSmall), child: CustomDivider()),
      ],):

      CustomContainer(child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
        Text('${index+1}. ', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
        ClipRRect(borderRadius: BorderRadius.circular(120),
            child: const CustomImage(width: Dimensions.imageSizeBig, height: Dimensions.imageSizeBig, image: "")),
        const SizedBox(width: Dimensions.paddingSizeSmall),
        Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Text("${benefitItem?.title}", maxLines: 1,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall)),
          Text(benefitItem?.description??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          EditDeleteSection(onEdit: (){}, onDelete: (){}),
          const SizedBox(height: Dimensions.paddingSizeExtraSmall),


        ])),


      ],
      )),
    );
  }
}

