import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/layout/list_layout_widget.dart';
import 'package:mighty_school/feature/cms_management/benifit/domain/model/benifit_model.dart';
import 'package:mighty_school/feature/cms_management/benifit/logic/benifit_controller.dart';
import 'package:mighty_school/feature/cms_management/benifit/presentation/widgets/benfit_item_widget.dart';
import 'package:mighty_school/feature/cms_management/benifit/presentation/widgets/create_new_benefit_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';

class BenefitListWidget extends StatelessWidget {
  final ScrollController scrollController;
  const BenefitListWidget({super.key, required this.scrollController});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<BenefitController>(
      initState: (val) => Get.find<BenefitController>().getBenefit(1),
      builder: (benefitController) {
        final benefitModel = benefitController.benefitModel;
        final benefitData = benefitModel?.data;

        return GenericListSection<BenefitItem>(
          sectionTitle: "cms_management".tr,
          pathItems: ["benefit".tr],
          addNewTitle: "add_new_benefit".tr,
          onAddNewTap: () => Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
            child: SizedBox(width: ResponsiveHelper.isDesktop(context) ? 600 : Get.width,
              child: const Padding(padding: EdgeInsets.all(Dimensions.paddingSizeDefault),
                child: CreateNewBenefitWidget())))),
          headings: const ["image", "title", "description", "action"],

          scrollController: scrollController,
          isLoading: benefitModel == null,
          totalSize: benefitData?.total ?? 0,
          offset: benefitData?.currentPage ?? 1,
          onPaginate: (offset) async => await benefitController.getBenefit(offset ?? 1),
          items: benefitData?.data ?? [],
          itemBuilder: (item, index) => BenefitItemWidget(benefitItem: item, index: index),
        );
      },
    );
  }
}