import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_text_field.dart';
import 'package:mighty_school/feature/cms_management/benifit/domain/model/benifit_model.dart';
import 'package:mighty_school/feature/cms_management/benifit/logic/benifit_controller.dart';
import 'package:mighty_school/feature/cms_management/benifit/presentation/widgets/benefit_image_widget.dart';
import 'package:mighty_school/util/dimensions.dart';

class CreateNewBenefitWidget extends StatefulWidget {
  final BenefitItem? benefitItem;
  const CreateNewBenefitWidget({super.key, this.benefitItem});

  @override
  State<CreateNewBenefitWidget> createState() => _CreateNewBenefitWidgetState();
}

class _CreateNewBenefitWidgetState extends State<CreateNewBenefitWidget> {
  TextEditingController titleController = TextEditingController();
  TextEditingController descriptionController = TextEditingController();


  @override
  void initState() {
    if(widget.benefitItem != null) {
      titleController.text = widget.benefitItem?.title??'';
      descriptionController.text = widget.benefitItem?.description??'';

    }
    super.initState();
  }


  @override
  Widget build(BuildContext context) {
    return GetBuilder<BenefitController>(
      builder: (benefitController) {
        return Column(mainAxisSize: MainAxisSize.min, children: [
          CustomTextField(title: "title".tr, hintText: "title".tr, controller: titleController, maxLength: 100),
          CustomTextField(title: "description".tr, minLines: 3, maxLines: 5, inputType: TextInputType.multiline,
            inputAction: TextInputAction.newline,
              hintText: "description".tr, controller: descriptionController, maxLength: 100),

          const BenefitImageWidget(),
          const SizedBox(height: Dimensions.paddingSizeLarge),
          benefitController.loading? const Center(child: CircularProgressIndicator()) :
          CustomButton(
            onTap: () {
              String title = titleController.text.trim();
              String description = descriptionController.text.trim();

              if(widget.benefitItem != null){
                benefitController.editBenefit(title, description, widget.benefitItem!.id!);
              }else {
                benefitController.createBenefit(title, description);
              }

            },
            text: widget.benefitItem != null?"update".tr : "add".tr,
          ),
        ]);
      }
    );
  }
}