class ConceptualModel {
  bool? status;
  String? message;
  Data? data;

  ConceptualModel({this.status, this.message, this.data});

  ConceptualModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class Data {
  int? currentPage;
  List<ConceptualVideoItem>? data;
  int? total;

  Data({this.currentPage, this.data, this.total});

  Data.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <ConceptualVideoItem>[];
      json['data'].forEach((v) {
        data!.add(ConceptualVideoItem.fromJson(v));
      });
    }

    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['current_page'] = currentPage;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }

    data['total'] = total;
    return data;
  }
}

class ConceptualVideoItem {
  int? id;
  int? instituteId;
  String? title;
  String? description;
  String? videoUrl;
  int? status;
  String? createdAt;

  ConceptualVideoItem(
      {this.id,
        this.instituteId,
        this.title,
        this.description,
        this.videoUrl,
        this.status,
        this.createdAt});

  ConceptualVideoItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    instituteId = json['institute_id'];
    title = json['title'];
    description = json['description'];
    videoUrl = json['video_url'];
    status = json['status'];
    createdAt = json['created_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['institute_id'] = instituteId;
    data['title'] = title;
    data['description'] = description;
    data['video_url'] = videoUrl;
    data['status'] = status;
    data['created_at'] = createdAt;
    return data;
  }
}

