import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_body.dart';
import 'package:mighty_school/util/app_constants.dart';

class ConceptualVideoRepository {
  final ApiClient apiClient;

  ConceptualVideoRepository({required this.apiClient});
  
  Future<Response?> getConceptualVideo(int page) async {
    return await apiClient.getData("${AppConstants.conceptual}?page=$page");
  }

  Future<Response?> createConceptualVideo(ConceptualBody body) async {
    return await apiClient.postData(AppConstants.conceptual, body.toJson());
  }

  Future<Response?> editConceptualVideo(ConceptualBody body, int id) async {
    return await apiClient.postData("${AppConstants.conceptual}/$id", body.toJson());
  }

  Future<Response?> deleteConceptualVideo(int id) async {
    return await apiClient.getData("${AppConstants.conceptual}/$id");
  }
}
  