import 'package:get/get.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_body.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_model.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/repository/conceptual_video_repository.dart';

class ConceptualVideoController extends GetxController implements GetxService {
  final ConceptualVideoRepository conceptualVideoRepository;
  ConceptualVideoController({required this.conceptualVideoRepository});


  ConceptualModel? conceptualModel;
  Future<void> getConceptualVideo(int page) async {
    Response? response = await conceptualVideoRepository.getConceptualVideo(page);
    if (response?.statusCode == 200) {
      if(page == 1) {
        conceptualModel = ConceptualModel.fromJson(response!.body);
      }else{
        conceptualModel?.data?.data?.addAll(ConceptualModel.fromJson(response?.body).data?.data ?? []);
        conceptualModel?.data?.total = ConceptualModel.fromJson(response?.body).data?.total;
        conceptualModel?.data?.currentPage = ConceptualModel.fromJson(response?.body).data?.currentPage;
      }
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  bool loading = false;
  Future<void> createConceptualVideo(ConceptualBody body) async {
    loading = true;
    update();
    Response? response = await conceptualVideoRepository.createConceptualVideo(body);
    if (response?.statusCode == 200) {
      loading = false;
      Get.back();
      showCustomSnackBar("added_successfully".tr, isError: false);
      getConceptualVideo(1);
    } else {
      loading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> editConceptualVideo(ConceptualBody body, int id) async {
    loading = true;
    update();
    Response? response = await conceptualVideoRepository.editConceptualVideo(body, id);
    if (response?.statusCode == 200) {
      loading = false;
      Get.back();
      showCustomSnackBar("updated_successfully".tr, isError: false);
      getConceptualVideo(1);
    } else {
      loading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> deleteConceptualVideo(int id) async {
    Response? response = await conceptualVideoRepository.deleteConceptualVideo(id);
    if (response?.statusCode == 200) {
      showCustomSnackBar("deleted_successfully".tr, isError: false);
      getConceptualVideo(1);
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }
}
  