import 'package:flutter/material.dart';
import 'package:flutter_linkify/flutter_linkify.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_model.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/logic/conceptual_video_controller.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/presentation/widgets/create_new_conceptual_video_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class ConceptualVideoItemWidget extends StatelessWidget {
  final ConceptualVideoItem? conceptualVideoItem;
  final int index;
  const ConceptualVideoItemWidget({super.key, this.conceptualVideoItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.symmetric(vertical: 5),
      child: ResponsiveHelper.isDesktop(context)?
      Column(children: [
        Row(crossAxisAlignment: CrossAxisAlignment.start, spacing: Dimensions.paddingSizeSmall, children: [

          Text("${index+1}. ", maxLines: 1,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Expanded(child: Text("${conceptualVideoItem?.title}", maxLines: 1,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Text(conceptualVideoItem?.description??'', maxLines: 2, overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Linkify(text : conceptualVideoItem?.videoUrl??'',
            onOpen: AppConstants.onOpen,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          EditDeleteSection(onEdit: (){
            Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
                child: SizedBox(width: ResponsiveHelper.isDesktop(context)? 600 : Get.width,
                  child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
                    child: CreateNewConceptualVideoWidget(conceptualVideoItem: conceptualVideoItem,),
                  ),
                )));
          }, onDelete: (){
            Get.dialog(ConfirmationDialog(
                title: "conceptual_video",
                content: "are_you_sure_to_delete_this_conceptual_video".tr,
                onTap: (){
                  Get.back();
                  Get.find<ConceptualVideoController>().deleteConceptualVideo(conceptualVideoItem?.id??0);
                }));
          }, horizontal: true)
        ]),
        const Padding(padding: EdgeInsets.symmetric(vertical:Dimensions.paddingSizeExtraSmall), child: CustomDivider()),
      ],):

      CustomContainer(child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
        Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Text("${conceptualVideoItem?.title}", maxLines: 1,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Text(conceptualVideoItem?.description??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Text(conceptualVideoItem?.videoUrl??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          EditDeleteSection(onEdit: (){}, onDelete: (){},),
          const SizedBox(height: Dimensions.paddingSizeExtraSmall),


        ])),


      ],
      )),
    );
  }
}

