import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/layout/list_layout_widget.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_model.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/logic/conceptual_video_controller.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/presentation/widgets/conceptual_video_item_widget.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/presentation/widgets/create_new_conceptual_video_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';

class ConceptualVideoListWidget extends StatelessWidget {
  final ScrollController scrollController;
  const ConceptualVideoListWidget({super.key, required this.scrollController});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ConceptualVideoController>(
      initState: (val) => Get.find<ConceptualVideoController>().getConceptualVideo(1),
      builder: (conceptualController) {
        final conceptualModel = conceptualController.conceptualModel;
        final conceptualData = conceptualModel?.data;

        return GenericListSection<ConceptualVideoItem>(
          sectionTitle: "cms_management".tr,
          pathItems: ["conceptual_video".tr],
          addNewTitle: "add".tr,
          onAddNewTap: () => Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
            child: SizedBox(width: ResponsiveHelper.isDesktop(context) ? 600 : Get.width,
              child: const Padding(padding: EdgeInsets.all(Dimensions.paddingSizeDefault),
                child: CreateNewConceptualVideoWidget())))),

          headings: const ["title", "description", "video_url", "action"],

          scrollController: scrollController,
          isLoading: conceptualModel == null,
          totalSize: conceptualData?.total ?? 0,
          offset: conceptualData?.currentPage ?? 1,
          onPaginate: (offset) async => await conceptualController.getConceptualVideo(offset ?? 1),

          items: conceptualData?.data ?? [],
          itemBuilder: (item, index) => ConceptualVideoItemWidget(conceptualVideoItem: item, index: index),
        );
      },
    );
  }
}