import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_text_field.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_body.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_model.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/logic/conceptual_video_controller.dart';
import 'package:mighty_school/util/dimensions.dart';

class CreateNewConceptualVideoWidget extends StatefulWidget {
  final ConceptualVideoItem? conceptualVideoItem;
  const CreateNewConceptualVideoWidget({super.key, this.conceptualVideoItem});

  @override
  State<CreateNewConceptualVideoWidget> createState() => _CreateNewConceptualVideoWidgetState();
}

class _CreateNewConceptualVideoWidgetState extends State<CreateNewConceptualVideoWidget> {
  TextEditingController titleController = TextEditingController();
  TextEditingController descriptionController = TextEditingController();
  TextEditingController videoUrlController = TextEditingController();


  @override
  void initState() {
    if(widget.conceptualVideoItem != null) {
      titleController.text = widget.conceptualVideoItem?.title??'';
      descriptionController.text = widget.conceptualVideoItem?.description??'';
      videoUrlController.text = widget.conceptualVideoItem?.videoUrl??'';

    }
    super.initState();
  }


  @override
  Widget build(BuildContext context) {
    return GetBuilder<ConceptualVideoController>(
      builder: (conceptualController) {
        return Column(mainAxisSize: MainAxisSize.min, children: [
          CustomTextField(title: "title".tr, hintText: "title".tr, controller: titleController, maxLength: 100),
          CustomTextField(title: "description".tr, minLines: 3, maxLines: 5, inputType: TextInputType.multiline,
            inputAction: TextInputAction.newline,
              hintText: "description".tr, controller: descriptionController, maxLength: 100),
          CustomTextField(title: "video_url".tr, hintText: "video_url".tr, controller: videoUrlController, maxLength: 100),


          const SizedBox(height: Dimensions.paddingSizeLarge),
          conceptualController.loading? const Center(child: CircularProgressIndicator()) :
          CustomButton(
            onTap: () {
              String title = titleController.text.trim();
              String description = descriptionController.text.trim();
              String videoUrl = videoUrlController.text.trim();
              ConceptualBody body = ConceptualBody(
                title: title,
                description: description,
                videoUrl: videoUrl,
                method: widget.conceptualVideoItem != null? "PUT" :"POST",
              );
              if(widget.conceptualVideoItem != null){

                conceptualController.editConceptualVideo(body, widget.conceptualVideoItem!.id!);
              }else {
                conceptualController.createConceptualVideo(body);
              }

            },
            text: widget.conceptualVideoItem != null?"update".tr : "add".tr,
          ),
        ]);
      }
    );
  }
}