import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/global_widget/custom_web_scroll_view_widget.dart';
import 'package:mighty_school/common/widget/custom_app_bar.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/domain/model/conceptual_video_model.dart';
import 'package:mighty_school/feature/cms_management/conceptual_video/presentation/widgets/create_new_conceptual_video_widget.dart';
import 'package:mighty_school/util/dimensions.dart';

class CreateNewFAqScreen extends StatefulWidget {
  final ConceptualVideoItem? conceptualVideoItem;
  const CreateNewFAqScreen({super.key, this.conceptualVideoItem});

  @override
  State<CreateNewFAqScreen> createState() => _CreateNewFAqScreenState();
}

class _CreateNewFAqScreenState extends State<CreateNewFAqScreen> {
  ScrollController scrollController = ScrollController();
  @override
  Widget build(BuildContext context) {
    return Scaffold(appBar: CustomAppBar(title: "faq".tr),
      body: CustomWebScrollView(controller: scrollController, slivers: [

        SliverToBoxAdapter(child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
          child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
            child: CreateNewConceptualVideoWidget(conceptualVideoItem: widget.conceptualVideoItem),
          ),
        ),)
      ],),
    );
  }
}
