import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/cms_management/faq/domain/model/faq_model.dart';
import 'package:mighty_school/feature/cms_management/faq/logic/faq_controller.dart';
import 'package:mighty_school/feature/cms_management/faq/presentation/widgets/create_new_faq_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class FaqItemWidget extends StatelessWidget {
  final FaqItem? faqItem;
  final int index;
  const FaqItemWidget({super.key, this.faqItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.symmetric(vertical: 5),
      child: ResponsiveHelper.isDesktop(context)?
      Column(children: [
        Row(crossAxisAlignment: CrossAxisAlignment.start, spacing: Dimensions.paddingSizeSmall, children: [
          Text("${index+1}", maxLines: 1,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Expanded(child: Text("${faqItem?.question}", maxLines: 1,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Text(faqItem?.answer??'', maxLines: 2, overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          EditDeleteSection(onEdit: (){
            Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
                child: SizedBox(width: ResponsiveHelper.isDesktop(context)? 600 : Get.width,
                  child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
                    child: CreateNewFaqWidget(faqItem: faqItem,),
                  ),
                )));
          }, onDelete: (){
            Get.dialog(ConfirmationDialog(
                title: "faq",
                content: "are_you_sure_to_delete_this_faq".tr,
                onTap: (){
                  Get.back();
                  Get.find<FaqController>().deleteFaq(faqItem?.id??0);
                }));
          }, horizontal: true)
        ]),
        const Padding(padding: EdgeInsets.symmetric(vertical:Dimensions.paddingSizeExtraSmall), child: CustomDivider()),
      ],):

      CustomContainer(child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
        ClipRRect(borderRadius: BorderRadius.circular(120),
            child: const CustomImage(width: Dimensions.imageSizeBig, height: Dimensions.imageSizeBig, image: "")),
        const SizedBox(width: Dimensions.paddingSizeSmall),
        Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Text("${faqItem?.question}", maxLines: 1,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Text(faqItem?.answer??'', maxLines: 2, overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          EditDeleteSection(onEdit: (){}, onDelete: (){},),
          const SizedBox(height: Dimensions.paddingSizeExtraSmall),


        ])),


      ],
      )),
    );
  }
}
