import 'package:flutter/material.dart';
import 'package:flutter_linkify/flutter_linkify.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/cms_management/feedback/domain/model/feedback_model.dart';
import 'package:mighty_school/feature/cms_management/feedback/logic/feedback_controller.dart';
import 'package:mighty_school/feature/cms_management/feedback/presentation/widgets/create_new_feedback_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/app_constants.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class FeedbackItemWidget extends StatelessWidget {
  final FeedbackItem? feedbackItem;
  final int index;
  const FeedbackItemWidget({super.key, this.feedbackItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.symmetric(vertical: 5),
      child: ResponsiveHelper.isDesktop(context)?
      Column(children: [
        Row(crossAxisAlignment: CrossAxisAlignment.start, spacing: Dimensions.paddingSizeSmall, children: [
          Text("${index+1}", maxLines: 1,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Expanded(child: Text("${feedbackItem?.name}", maxLines: 1,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Text(feedbackItem?.university??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Text(feedbackItem?.rank.toString()??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Text(feedbackItem?.description??'', maxLines: 2,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          Expanded(child: Linkify(text :feedbackItem?.videoUrl??'', onOpen: AppConstants.onOpen,maxLines: 1,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
          EditDeleteSection(onEdit: (){
            Get.dialog(Dialog(shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
                child: SizedBox(width: ResponsiveHelper.isDesktop(context)? 600 : Get.width,
                  child: Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
                    child: CreateNewFeedbackWidget(feedbackItem: feedbackItem,),
                  ),
                )));
          }, onDelete: (){
            Get.dialog(ConfirmationDialog(
                title: "feedback",
                content: "are_you_sure_to_delete_this_feedback".tr,
                onTap: (){
                  Get.back();
                  Get.find<FeedbackController>().deleteFeedback(feedbackItem?.id??0);
                }));
          }, horizontal: true)
        ]),
        const Padding(padding: EdgeInsets.symmetric(vertical:Dimensions.paddingSizeExtraSmall), child: CustomDivider()),
      ],):

      CustomContainer(child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
        ClipRRect(borderRadius: BorderRadius.circular(120),
            child: const CustomImage(width: Dimensions.imageSizeBig, height: Dimensions.imageSizeBig, image: "")),
        const SizedBox(width: Dimensions.paddingSizeSmall),
        Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Text("${feedbackItem?.name}", maxLines: 1,overflow: TextOverflow.ellipsis,
            style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Text(feedbackItem?.university??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Text(feedbackItem?.rank.toString()??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Text(feedbackItem?.description??'', maxLines: 2,overflow: TextOverflow.ellipsis, style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          Text(feedbackItem?.videoUrl??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
          EditDeleteSection(onEdit: (){}, onDelete: (){},),
          const SizedBox(height: Dimensions.paddingSizeExtraSmall),
        ])),
      ],
      )),
    );
  }
}

