import 'package:flutter/material.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/fees_management/fees_mapping/domain/model/fees_mapping_model.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class FeesMappingItemWidget extends StatelessWidget {
  final FeesMappingItem feesMappingItem;
  final int index;
  const FeesMappingItemWidget({super.key, required this.feesMappingItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.fromLTRB(Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, 0),
      child: Row(spacing: Dimensions.paddingSizeDefault, crossAxisAlignment: CrossAxisAlignment.start, children: [

        NumberingWidget(index: index),
        Expanded(child: Text('${feesMappingItem.feeHead?.name}', style: textRegular.copyWith())),
        Expanded(child: Text('${feesMappingItem.feeLedger?.ledgerName}', style: textRegular.copyWith())),
      ],
      ),
    );
  }
}
