import 'package:get/get.dart';
import 'package:image_picker/image_picker.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/feature/hostel_management/hostel/domain/model/hostel_body.dart';
import 'package:mighty_school/feature/hostel_management/hostel/domain/model/hostel_model.dart';
import 'package:mighty_school/feature/hostel_management/hostel/domain/repository/hostel_repository.dart';

class HostelController extends GetxController implements GetxService {
  final HostelRepository hostelRepository;
  HostelController({required this.hostelRepository});

  bool isLoading = false;
  HostelModel? hostelModel;
  XFile? selectedImage;

  Future<void> getHostelList(int page) async {
    Response? response = await hostelRepository.getHostelList(page);
    if (response?.statusCode == 200) {
      if (page == 1) {
        hostelModel = HostelModel.fromJson(response?.body);
      } else {
        hostelModel?.data?.data?.addAll(HostelModel.fromJson(response?.body).data!.data!);
        hostelModel?.data?.total = HostelModel.fromJson(response?.body).data!.total;
        hostelModel?.data?.currentPage = HostelModel.fromJson(response?.body).data!.currentPage;
      }
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Add new hostel
  Future<void> addNewHostel(HostelBody hostelBody) async {
    isLoading = true;
    update();
    Response? response = await hostelRepository.addNewHostel(hostelBody, selectedImage);
    if (response?.statusCode == 200 || response?.statusCode == 201) {
      isLoading = false;
      Get.back();
      showCustomSnackBar('hostel_added_successfully'.tr, isError: false);
      getHostelList(1);
      clearForm();
    } else {
      isLoading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Update hostel
  Future<void> updateHostel(int id, HostelBody hostelBody) async {
    isLoading = true;
    update();
    Response? response = await hostelRepository.updateHostel(id, hostelBody, selectedImage);
    if (response?.statusCode == 200) {
      isLoading = false;
      Get.back();
      showCustomSnackBar('hostel_updated_successfully'.tr, isError: false);
      getHostelList(1);
      clearForm();
    } else {
      isLoading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Delete hostel
  Future<void> deleteHostel(int id) async {
    Response? response = await hostelRepository.deleteHostel(id);
    if (response?.statusCode == 200) {
      showCustomSnackBar('hostel_deleted_successfully'.tr, isError: false);
      getHostelList(1);
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Set selected image
  void setSelectedImage(XFile? image) {
    selectedImage = image;
    update();
  }

  // Clear form
  void clearForm() {
    selectedImage = null;
    update();
  }

  // Status list
  List<String> statusList = ["Active", "Inactive"];
  String selectedStatus = "Active";

  void setSelectedStatus(String status) {
    selectedStatus = status;
    update();
  }

  // Hostel selection for member assignment
  HostelItem? selectedHostelItem;

  void setSelectedHostel(HostelItem hostel) {
    selectedHostelItem = hostel;
    update();
  }
}
  