class HostelBillModel {
  bool? status;
  String? message;
  HostelBillData? data;

  HostelBillModel({this.status, this.message, this.data});

  HostelBillModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? HostelBillData.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class HostelBillData {
  int? currentPage;
  List<HostelBillItem>? data;
  String? firstPageUrl;
  int? from;
  int? lastPage;
  String? lastPageUrl;
  String? nextPageUrl;
  String? path;
  int? perPage;
  String? prevPageUrl;
  int? to;
  int? total;

  HostelBillData({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  HostelBillData.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <HostelBillItem>[];
      json['data'].forEach((v) {
        data!.add(HostelBillItem.fromJson(v));
      });
    }
    firstPageUrl = json['first_page_url'];
    from = json['from'];
    lastPage = json['last_page'];
    lastPageUrl = json['last_page_url'];
    nextPageUrl = json['next_page_url'];
    path = json['path'];
    perPage = json['per_page'];
    prevPageUrl = json['prev_page_url'];
    to = json['to'];
    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['current_page'] = currentPage;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    data['first_page_url'] = firstPageUrl;
    data['from'] = from;
    data['last_page'] = lastPage;
    data['last_page_url'] = lastPageUrl;
    data['next_page_url'] = nextPageUrl;
    data['path'] = path;
    data['per_page'] = perPage;
    data['prev_page_url'] = prevPageUrl;
    data['to'] = to;
    data['total'] = total;
    return data;
  }
}

class HostelBillItem {
  int? id;
  String? billNumber;
  int? studentId;
  int? hostelId;
  String? billMonth;
  String? billYear;
  double? roomRent;
  double? mealCharges;
  double? otherCharges;
  double? totalAmount;
  double? paidAmount;
  double? dueAmount;
  String? status;
  String? dueDate;
  String? createdAt;
  String? updatedAt;
  StudentInfo? student;
  HostelInfo? hostel;

  HostelBillItem({
    this.id,
    this.billNumber,
    this.studentId,
    this.hostelId,
    this.billMonth,
    this.billYear,
    this.roomRent,
    this.mealCharges,
    this.otherCharges,
    this.totalAmount,
    this.paidAmount,
    this.dueAmount,
    this.status,
    this.dueDate,
    this.createdAt,
    this.updatedAt,
    this.student,
    this.hostel,
  });

  HostelBillItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    billNumber = json['bill_number'];
    studentId = json['student_id'];
    hostelId = json['hostel_id'];
    billMonth = json['bill_month'];
    billYear = json['bill_year'];
    roomRent = json['room_rent']?.toDouble();
    mealCharges = json['meal_charges']?.toDouble();
    otherCharges = json['other_charges']?.toDouble();
    totalAmount = json['total_amount']?.toDouble();
    paidAmount = json['paid_amount']?.toDouble();
    dueAmount = json['due_amount']?.toDouble();
    status = json['status'];
    dueDate = json['due_date'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    student = json['student'] != null ? StudentInfo.fromJson(json['student']) : null;
    hostel = json['hostel'] != null ? HostelInfo.fromJson(json['hostel']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['bill_number'] = billNumber;
    data['student_id'] = studentId;
    data['hostel_id'] = hostelId;
    data['bill_month'] = billMonth;
    data['bill_year'] = billYear;
    data['room_rent'] = roomRent;
    data['meal_charges'] = mealCharges;
    data['other_charges'] = otherCharges;
    data['total_amount'] = totalAmount;
    data['paid_amount'] = paidAmount;
    data['due_amount'] = dueAmount;
    data['status'] = status;
    data['due_date'] = dueDate;
    data['created_at'] = createdAt;
    data['updated_at'] = updatedAt;
    if (student != null) {
      data['student'] = student!.toJson();
    }
    if (hostel != null) {
      data['hostel'] = hostel!.toJson();
    }
    return data;
  }
}

class StudentInfo {
  int? id;
  String? firstName;
  String? lastName;
  String? registerNo;
  String? image;

  StudentInfo({this.id, this.firstName, this.lastName, this.registerNo, this.image});

  StudentInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    firstName = json['first_name'];
    lastName = json['last_name'];
    registerNo = json['register_no'];
    image = json['image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['first_name'] = firstName;
    data['last_name'] = lastName;
    data['register_no'] = registerNo;
    data['image'] = image;
    return data;
  }
}

class HostelInfo {
  int? id;
  String? name;
  String? address;

  HostelInfo({this.id, this.name, this.address});

  HostelInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['address'] = address;
    return data;
  }
}