import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/hostel_management/hostel_categories/domain/model/hostel_category_model.dart';
import 'package:mighty_school/feature/hostel_management/hostel_categories/logic/hostel_categories_controller.dart';
import 'package:mighty_school/feature/hostel_management/hostel_categories/presentation/screens/add_new_hostel_category_screen.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class HostelCategoryItemWidget extends StatelessWidget {
  final HostelCategoryItem categoryItem;
  final int index;
  
  const HostelCategoryItemWidget({
    super.key, 
    required this.categoryItem, 
    required this.index
  });

  @override
  Widget build(BuildContext context) {
    return GetBuilder<HostelCategoriesController>(
      builder: (categoryController) {
        return ResponsiveHelper.isDesktop(context) 
          ? _buildDesktopView(context, categoryController)
          : _buildMobileView(context, categoryController);
      },
    );
  }

  Widget _buildDesktopView(BuildContext context, HostelCategoriesController categoryController) {
    return CustomContainer(
      child: Row(
        children: [
          // Numbering
          NumberingWidget(index: index),
          
          // Name
          Expanded(
            flex: 2,
            child: Text(
              categoryItem.name ?? '',
              style: textRegular.copyWith(fontSize: Dimensions.fontSizeDefault),
              maxLines: 2,
              overflow: TextOverflow.ellipsis,
            ),
          ),
          
          // Description
          Expanded(
            flex: 3,
            child: Text(
              categoryItem.description ?? '',
              style: textRegular.copyWith(fontSize: Dimensions.fontSizeDefault),
              maxLines: 2,
              overflow: TextOverflow.ellipsis,
            ),
          ),
          
          // Actions
          Expanded(
            flex: 1,
            child: EditDeleteSection(
              onEdit: () => Get.dialog(AddNewHostelCategoryScreen(categoryId: categoryItem.id)),
              onDelete: () => categoryController.deleteHostelCategory(categoryItem.id!),
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildMobileView(BuildContext context, HostelCategoriesController categoryController) {
    return CustomContainer(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          // Name
          Text(
            categoryItem.name ?? '',
            style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),
            maxLines: 1,
            overflow: TextOverflow.ellipsis,
          ),
          
          const SizedBox(height: Dimensions.paddingSizeExtraSmall),
          
          // Description
          if (categoryItem.description != null && categoryItem.description!.isNotEmpty)
            Text(
              categoryItem.description!,
              style: textRegular.copyWith(
                fontSize: Dimensions.fontSizeSmall,
                color: Theme.of(context).hintColor,
              ),
              maxLines: 3,
              overflow: TextOverflow.ellipsis,
            ),
          
          const SizedBox(height: Dimensions.paddingSizeSmall),
          
          // Actions
          EditDeleteSection(
            onEdit: () => Get.dialog(AddNewHostelCategoryScreen(categoryId: categoryItem.id)),
            onDelete: () => categoryController.deleteHostelCategory(categoryItem.id!),
          ),
        ],
      ),
    );
  }
}
