class HostelMealEntryModel {
  bool? status;
  String? message;
  HostelMealEntryData? data;

  HostelMealEntryModel({this.status, this.message, this.data});

  HostelMealEntryModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? HostelMealEntryData.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class HostelMealEntryData {
  int? currentPage;
  List<HostelMealEntryItem>? data;
  String? firstPageUrl;
  int? from;
  int? lastPage;
  String? lastPageUrl;
  String? nextPageUrl;
  String? path;
  int? perPage;
  String? prevPageUrl;
  int? to;
  int? total;

  HostelMealEntryData({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  HostelMealEntryData.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <HostelMealEntryItem>[];
      json['data'].forEach((v) {
        data!.add(HostelMealEntryItem.fromJson(v));
      });
    }
    firstPageUrl = json['first_page_url'];
    from = json['from'];
    lastPage = json['last_page'];
    lastPageUrl = json['last_page_url'];
    nextPageUrl = json['next_page_url'];
    path = json['path'];
    perPage = json['per_page'];
    prevPageUrl = json['prev_page_url'];
    to = json['to'];
    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['current_page'] = currentPage;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    data['first_page_url'] = firstPageUrl;
    data['from'] = from;
    data['last_page'] = lastPage;
    data['last_page_url'] = lastPageUrl;
    data['next_page_url'] = nextPageUrl;
    data['path'] = path;
    data['per_page'] = perPage;
    data['prev_page_url'] = prevPageUrl;
    data['to'] = to;
    data['total'] = total;
    return data;
  }
}

class HostelMealEntryItem {
  int? id;
  int? studentId;
  int? mealId;
  String? entryDate;
  String? mealTime;
  int? quantity;
  double? amount;
  String? status;
  String? createdAt;
  String? updatedAt;
  StudentInfo? student;
  MealInfo? meal;

  HostelMealEntryItem({
    this.id,
    this.studentId,
    this.mealId,
    this.entryDate,
    this.mealTime,
    this.quantity,
    this.amount,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.student,
    this.meal,
  });

  HostelMealEntryItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    studentId = json['student_id'];
    mealId = json['meal_id'];
    entryDate = json['entry_date'];
    mealTime = json['meal_time'];
    quantity = json['quantity'];
    amount = json['amount']?.toDouble();
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    student = json['student'] != null ? StudentInfo.fromJson(json['student']) : null;
    meal = json['meal'] != null ? MealInfo.fromJson(json['meal']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['student_id'] = studentId;
    data['meal_id'] = mealId;
    data['entry_date'] = entryDate;
    data['meal_time'] = mealTime;
    data['quantity'] = quantity;
    data['amount'] = amount;
    data['status'] = status;
    data['created_at'] = createdAt;
    data['updated_at'] = updatedAt;
    if (student != null) {
      data['student'] = student!.toJson();
    }
    if (meal != null) {
      data['meal'] = meal!.toJson();
    }
    return data;
  }
}

class StudentInfo {
  int? id;
  String? firstName;
  String? lastName;
  String? registerNo;
  String? image;

  StudentInfo({this.id, this.firstName, this.lastName, this.registerNo, this.image});

  StudentInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    firstName = json['first_name'];
    lastName = json['last_name'];
    registerNo = json['register_no'];
    image = json['image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['first_name'] = firstName;
    data['last_name'] = lastName;
    data['register_no'] = registerNo;
    data['image'] = image;
    return data;
  }
}

class MealInfo {
  int? id;
  String? name;
  String? mealType;
  double? price;

  MealInfo({this.id, this.name, this.mealType, this.price});

  MealInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    mealType = json['meal_type'];
    price = json['price']?.toDouble();
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['meal_type'] = mealType;
    data['price'] = price;
    return data;
  }
}
