class HostelMealPlanModel {
  bool? status;
  String? message;
  HostelMealPlanData? data;

  HostelMealPlanModel({this.status, this.message, this.data});

  HostelMealPlanModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? HostelMealPlanData.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class HostelMealPlanData {
  int? currentPage;
  List<HostelMealPlanItem>? data;
  String? firstPageUrl;
  int? from;
  int? lastPage;
  String? lastPageUrl;
  String? nextPageUrl;
  String? path;
  int? perPage;
  String? prevPageUrl;
  int? to;
  int? total;

  HostelMealPlanData({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  HostelMealPlanData.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <HostelMealPlanItem>[];
      json['data'].forEach((v) {
        data!.add(HostelMealPlanItem.fromJson(v));
      });
    }
    firstPageUrl = json['first_page_url'];
    from = json['from'];
    lastPage = json['last_page'];
    lastPageUrl = json['last_page_url'];
    nextPageUrl = json['next_page_url'];
    path = json['path'];
    perPage = json['per_page'];
    prevPageUrl = json['prev_page_url'];
    to = json['to'];
    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['current_page'] = currentPage;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    data['first_page_url'] = firstPageUrl;
    data['from'] = from;
    data['last_page'] = lastPage;
    data['last_page_url'] = lastPageUrl;
    data['next_page_url'] = nextPageUrl;
    data['path'] = path;
    data['per_page'] = perPage;
    data['prev_page_url'] = prevPageUrl;
    data['to'] = to;
    data['total'] = total;
    return data;
  }
}

class HostelMealPlanItem {
  int? id;
  String? name;
  String? description;
  String? planType;
  double? monthlyPrice;
  double? dailyPrice;
  String? status;
  int? hostelId;
  String? createdAt;
  String? updatedAt;
  HostelInfo? hostel;
  List<MealPlanMeal>? meals;

  HostelMealPlanItem({
    this.id,
    this.name,
    this.description,
    this.planType,
    this.monthlyPrice,
    this.dailyPrice,
    this.status,
    this.hostelId,
    this.createdAt,
    this.updatedAt,
    this.hostel,
    this.meals,
  });

  HostelMealPlanItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    description = json['description'];
    planType = json['plan_type'];
    monthlyPrice = json['monthly_price']?.toDouble();
    dailyPrice = json['daily_price']?.toDouble();
    status = json['status'];
    hostelId = json['hostel_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    hostel = json['hostel'] != null ? HostelInfo.fromJson(json['hostel']) : null;
    if (json['meals'] != null) {
      meals = <MealPlanMeal>[];
      json['meals'].forEach((v) {
        meals!.add(MealPlanMeal.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['description'] = description;
    data['plan_type'] = planType;
    data['monthly_price'] = monthlyPrice;
    data['daily_price'] = dailyPrice;
    data['status'] = status;
    data['hostel_id'] = hostelId;
    data['created_at'] = createdAt;
    data['updated_at'] = updatedAt;
    if (hostel != null) {
      data['hostel'] = hostel!.toJson();
    }
    if (meals != null) {
      data['meals'] = meals!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class HostelInfo {
  int? id;
  String? name;

  HostelInfo({this.id, this.name});

  HostelInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class MealPlanMeal {
  int? id;
  String? name;
  String? mealType;
  double? price;

  MealPlanMeal({this.id, this.name, this.mealType, this.price});

  MealPlanMeal.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    mealType = json['meal_type'];
    price = json['price']?.toDouble();
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['meal_type'] = mealType;
    data['price'] = price;
    return data;
  }
}