import 'package:get/get.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/feature/hostel_management/hostel_meal_plan/domain/model/hostel_meal_plan_body.dart';
import 'package:mighty_school/feature/hostel_management/hostel_meal_plan/domain/repository/hostel_meal_plan_repository.dart';

class HostelMealPlanController extends GetxController implements GetxService {
  final HostelMealPlanRepository hostelMealPlanRepository;
  HostelMealPlanController({required this.hostelMealPlanRepository});

  Future<void> getHostelMealPlan() async {
    Response? response = await hostelMealPlanRepository.getHostelMealPlansList(1);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> createHostelMealPlan(HostelMealPlanBody mealPlanBody) async {
    Response? response = await hostelMealPlanRepository.addNewHostelMealPlan(mealPlanBody);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> editHostelMealPlan(int id, HostelMealPlanBody mealPlanBody) async {
    Response? response = await hostelMealPlanRepository.updateHostelMealPlan(id, mealPlanBody);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> deleteHostelMealPlan(int id) async {
    Response? response = await hostelMealPlanRepository.deleteHostelMealPlan(id);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }
}
  