import 'package:get/get.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/feature/hostel_management/hostel_meals/domain/model/hostel_meal_body.dart';
import 'package:mighty_school/feature/hostel_management/hostel_meals/domain/repository/hostel_meals_repository.dart';

class HostelMealsController extends GetxController implements GetxService {
  final HostelMealsRepository hostelMealsRepository;
  HostelMealsController({required this.hostelMealsRepository});

  Future<void> getHostelMeals() async {
    Response? response = await hostelMealsRepository.getHostelMealsList(1);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> createHostelMeals(HostelMealBody mealBody) async {
    Response? response = await hostelMealsRepository.addNewHostelMeal(mealBody);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> editHostelMeals(int id, HostelMealBody mealBody) async {
    Response? response = await hostelMealsRepository.updateHostelMeal(id, mealBody);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> deleteHostelMeals(int id) async {
    Response? response = await hostelMealsRepository.deleteHostelMeal(id);
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }
}
  