class HostelMemberModel {
  bool? status;
  String? message;
  HostelMemberData? data;

  HostelMemberModel({this.status, this.message, this.data});

  HostelMemberModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? HostelMemberData.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class HostelMemberData {
  int? currentPage;
  List<HostelMemberItem>? data;
  String? firstPageUrl;
  int? from;
  int? lastPage;
  String? lastPageUrl;
  String? nextPageUrl;
  String? path;
  int? perPage;
  String? prevPageUrl;
  int? to;
  int? total;

  HostelMemberData({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  HostelMemberData.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <HostelMemberItem>[];
      json['data'].forEach((v) {
        data!.add(HostelMemberItem.fromJson(v));
      });
    }
    firstPageUrl = json['first_page_url'];
    from = json['from'];
    lastPage = json['last_page'];
    lastPageUrl = json['last_page_url'];
    nextPageUrl = json['next_page_url'];
    path = json['path'];
    perPage = json['per_page'];
    prevPageUrl = json['prev_page_url'];
    to = json['to'];
    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['current_page'] = currentPage;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    data['first_page_url'] = firstPageUrl;
    data['from'] = from;
    data['last_page'] = lastPage;
    data['last_page_url'] = lastPageUrl;
    data['next_page_url'] = nextPageUrl;
    data['path'] = path;
    data['per_page'] = perPage;
    data['prev_page_url'] = prevPageUrl;
    data['to'] = to;
    data['total'] = total;
    return data;
  }
}

class HostelMemberItem {
  int? id;
  int? hostelId;
  int? studentId;
  String? joinDate;
  String? leaveDate;
  String? status;
  String? createdAt;
  String? updatedAt;
  HostelInfo? hostel;
  StudentInfo? student;

  HostelMemberItem({
    this.id,
    this.hostelId,
    this.studentId,
    this.joinDate,
    this.leaveDate,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.hostel,
    this.student,
  });

  HostelMemberItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    hostelId = json['hostel_id'];
    studentId = json['student_id'];
    joinDate = json['join_date'];
    leaveDate = json['leave_date'];
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    hostel = json['hostel'] != null ? HostelInfo.fromJson(json['hostel']) : null;
    student = json['student'] != null ? StudentInfo.fromJson(json['student']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['hostel_id'] = hostelId;
    data['student_id'] = studentId;
    data['join_date'] = joinDate;
    data['leave_date'] = leaveDate;
    data['status'] = status;
    data['created_at'] = createdAt;
    data['updated_at'] = updatedAt;
    if (hostel != null) {
      data['hostel'] = hostel!.toJson();
    }
    if (student != null) {
      data['student'] = student!.toJson();
    }
    return data;
  }
}

class HostelInfo {
  int? id;
  String? name;
  String? address;

  HostelInfo({this.id, this.name, this.address});

  HostelInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['address'] = address;
    return data;
  }
}

class StudentInfo {
  int? id;
  String? firstName;
  String? lastName;
  String? registerNo;
  String? image;

  StudentInfo({this.id, this.firstName, this.lastName, this.registerNo, this.image});

  StudentInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    firstName = json['first_name'];
    lastName = json['last_name'];
    registerNo = json['register_no'];
    image = json['image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['first_name'] = firstName;
    data['last_name'] = lastName;
    data['register_no'] = registerNo;
    data['image'] = image;
    return data;
  }
}
