import 'package:get/get.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/common/widget/custom_snackbar.dart';
import 'package:mighty_school/feature/hostel_management/hostel_members/domain/model/hostel_member_body.dart';
import 'package:mighty_school/feature/hostel_management/hostel_members/domain/model/hostel_member_model.dart';
import 'package:mighty_school/feature/hostel_management/hostel_members/domain/repository/hostel_members_repository.dart';

class HostelMembersController extends GetxController implements GetxService {
  final HostelMembersRepository hostelMembersRepository;
  HostelMembersController({required this.hostelMembersRepository});

  bool isLoading = false;
  HostelMemberModel? hostelMemberModel;

  // Get hostel members list
  Future<void> getHostelMembersList({int page = 1}) async {
    if (page == 1) {
      isLoading = true;
      update();
    }

    Response? response = await hostelMembersRepository.getHostelMembersList(page);
    if (response?.statusCode == 200) {
      if (page == 1) {
        hostelMemberModel = HostelMemberModel.fromJson(response?.body);
      } else {
        hostelMemberModel?.data?.data?.addAll(HostelMemberModel.fromJson(response?.body).data!.data!);
        hostelMemberModel?.data?.total = HostelMemberModel.fromJson(response?.body).data!.total;
        hostelMemberModel?.data?.currentPage = HostelMemberModel.fromJson(response?.body).data!.currentPage;
      }
      isLoading = false;
    } else {
      isLoading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Add new hostel member
  Future<void> addNewHostelMember(HostelMemberBody memberBody) async {
    isLoading = true;
    update();

    Response? response = await hostelMembersRepository.addNewHostelMember(memberBody);
    if (response?.statusCode == 200 || response?.statusCode == 201) {
      isLoading = false;
      Get.back();
      showCustomSnackBar('hostel_member_added_successfully'.tr, isError: false);
      getHostelMembersList();
    } else {
      isLoading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Update hostel member
  Future<void> updateHostelMember(int id, HostelMemberBody memberBody) async {
    isLoading = true;
    update();

    Response? response = await hostelMembersRepository.updateHostelMember(id, memberBody);
    if (response?.statusCode == 200) {
      isLoading = false;
      Get.back();
      showCustomSnackBar('hostel_member_updated_successfully'.tr, isError: false);
      getHostelMembersList();
    } else {
      isLoading = false;
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Delete hostel member
  Future<void> deleteHostelMember(int id) async {
    Response? response = await hostelMembersRepository.deleteHostelMember(id);
    if (response?.statusCode == 200) {
      showCustomSnackBar('hostel_member_deleted_successfully'.tr, isError: false);
      getHostelMembersList();
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  // Status list
  List<String> statusList = ["Active", "Inactive"];
  String selectedStatus = "Active";

  void setSelectedStatus(String status) {
    selectedStatus = status;
    update();
  }
}
  