class HostelRoomModel {
  bool? status;
  String? message;
  HostelRoomData? data;

  HostelRoomModel({this.status, this.message, this.data});

  HostelRoomModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    message = json['message'];
    data = json['data'] != null ? HostelRoomData.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['status'] = status;
    data['message'] = message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class HostelRoomData {
  int? currentPage;
  List<HostelRoomItem>? data;
  String? firstPageUrl;
  int? from;
  int? lastPage;
  String? lastPageUrl;
  String? nextPageUrl;
  String? path;
  int? perPage;
  String? prevPageUrl;
  int? to;
  int? total;

  HostelRoomData({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  HostelRoomData.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    if (json['data'] != null) {
      data = <HostelRoomItem>[];
      json['data'].forEach((v) {
        data!.add(HostelRoomItem.fromJson(v));
      });
    }
    firstPageUrl = json['first_page_url'];
    from = json['from'];
    lastPage = json['last_page'];
    lastPageUrl = json['last_page_url'];
    nextPageUrl = json['next_page_url'];
    path = json['path'];
    perPage = json['per_page'];
    prevPageUrl = json['prev_page_url'];
    to = json['to'];
    total = json['total'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['current_page'] = currentPage;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    data['first_page_url'] = firstPageUrl;
    data['from'] = from;
    data['last_page'] = lastPage;
    data['last_page_url'] = lastPageUrl;
    data['next_page_url'] = nextPageUrl;
    data['path'] = path;
    data['per_page'] = perPage;
    data['prev_page_url'] = prevPageUrl;
    data['to'] = to;
    data['total'] = total;
    return data;
  }
}

class HostelRoomItem {
  int? id;
  String? roomNumber;
  String? roomType;
  int? capacity;
  int? currentOccupancy;
  String? description;
  String? status;
  int? hostelId;
  String? createdAt;
  String? updatedAt;
  HostelInfo? hostel;

  HostelRoomItem({
    this.id,
    this.roomNumber,
    this.roomType,
    this.capacity,
    this.currentOccupancy,
    this.description,
    this.status,
    this.hostelId,
    this.createdAt,
    this.updatedAt,
    this.hostel,
  });

  HostelRoomItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    roomNumber = json['room_number'];
    roomType = json['room_type'];
    capacity = json['capacity'];
    currentOccupancy = json['current_occupancy'];
    description = json['description'];
    status = json['status'];
    hostelId = json['hostel_id'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    hostel = json['hostel'] != null ? HostelInfo.fromJson(json['hostel']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['room_number'] = roomNumber;
    data['room_type'] = roomType;
    data['capacity'] = capacity;
    data['current_occupancy'] = currentOccupancy;
    data['description'] = description;
    data['status'] = status;
    data['hostel_id'] = hostelId;
    data['created_at'] = createdAt;
    data['updated_at'] = updatedAt;
    if (hostel != null) {
      data['hostel'] = hostel!.toJson();
    }
    return data;
  }
}

class HostelInfo {
  int? id;
  String? name;
  String? address;

  HostelInfo({this.id, this.name, this.address});

  HostelInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['address'] = address;
    return data;
  }
}
