import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_app_bar.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_text_field.dart';
import 'package:mighty_school/common/widget/custom_dropdown.dart';
import 'package:mighty_school/feature/hostel_management/hostel_rooms/domain/model/hostel_room_body.dart';
import 'package:mighty_school/feature/hostel_management/hostel_rooms/logic/hostel_rooms_controller.dart';
import 'package:mighty_school/feature/hostel_management/hostel/logic/hostel_controller.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';

class AddNewHostelRoomScreen extends StatefulWidget {
  final int? roomId;
  
  const AddNewHostelRoomScreen({super.key, this.roomId});

  @override
  State<AddNewHostelRoomScreen> createState() => _AddNewHostelRoomScreenState();
}

class _AddNewHostelRoomScreenState extends State<AddNewHostelRoomScreen> {
  final GlobalKey<FormState> formKey = GlobalKey<FormState>();
  final TextEditingController roomNumberController = TextEditingController();
  final TextEditingController capacityController = TextEditingController();
  final TextEditingController descriptionController = TextEditingController();

  @override
  void initState() {
    super.initState();
    Get.find<HostelController>().getHostelList(1);
    if (widget.roomId != null) {
      _loadRoomData();
    }
  }

  void _loadRoomData() {
    // Load existing room data for editing
    final roomsController = Get.find<HostelRoomsController>();
    final room = roomsController.hostelRoomModel?.data?.data?.firstWhere(
      (room) => room.id == widget.roomId,

    );
    
    if (room != null) {
      roomNumberController.text = room.roomNumber ?? '';
      capacityController.text = room.capacity?.toString() ?? '';
      descriptionController.text = room.description ?? '';
      roomsController.setSelectedRoomType(room.roomType ?? 'Single');
      roomsController.setSelectedStatus(room.status ?? 'Available');
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomAppBar(
        title: widget.roomId != null ? "edit_hostel_room".tr : "add_new_hostel_room".tr,
      ),
      body: GetBuilder<HostelRoomsController>(
        builder: (roomsController) {
          return SingleChildScrollView(
            padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
            child: Form(
              key: formKey,
              child: CustomContainer(
                showShadow: ResponsiveHelper.isDesktop(context),
                child: Column(
                  children: [
                    // Room Number
                    CustomTextField(
                      controller: roomNumberController,
                      labelText: "room_number".tr,
                      isRequired: true,
                      validator: (value) {
                        if (value == null || value.isEmpty) {
                          return "room_number_required".tr;
                        }
                        return null;
                      },
                    ),
                    
                    const SizedBox(height: Dimensions.paddingSizeDefault),
                    
                    // Hostel Selection

                    const SizedBox(height: Dimensions.paddingSizeDefault),
                    
                    // Room Type

                    
                    const SizedBox(height: Dimensions.paddingSizeDefault),
                    
                    // Capacity
                    CustomTextField(
                      controller: capacityController,
                      labelText: "capacity".tr,
                      isRequired: true,
                      validator: (value) {
                        if (value == null || value.isEmpty) {
                          return "capacity_required".tr;
                        }
                        if (int.tryParse(value) == null) {
                          return "invalid_number".tr;
                        }
                        return null;
                      },
                    ),
                    
                    const SizedBox(height: Dimensions.paddingSizeDefault),
                    

                    
                    const SizedBox(height: Dimensions.paddingSizeDefault),
                    
                    // Description
                    CustomTextField(
                      controller: descriptionController,
                      labelText: "description".tr,
                      maxLines: 3,
                    ),
                    
                    const SizedBox(height: Dimensions.paddingSizeLarge),
                    
                    // Submit button
                    CustomButton(
                      text: widget.roomId != null ? "update".tr : "add".tr,
                      onTap: () {
                        if (formKey.currentState!.validate()) {
                          HostelRoomBody roomBody = HostelRoomBody(
                            roomNumber: roomNumberController.text.trim(),
                            roomType: roomsController.selectedRoomType,
                            capacity: capacityController.text.trim(),
                            description: descriptionController.text.trim().isEmpty ? null : descriptionController.text.trim(),
                            status: roomsController.selectedStatus,
                            hostelId: "1", // This should be selected from dropdown
                          );
                          
                          if (widget.roomId != null) {
                            roomsController.updateHostelRoom(widget.roomId!, roomBody);
                          } else {
                            roomsController.addNewHostelRoom(roomBody);
                          }
                        }
                      },
                    ),
                  ],
                ),
              ),
            ),
          );
        },
      ),
    );
  }
}
