import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/institute/controller/institute_controller.dart';
import 'package:mighty_school/feature/institute/domain/models/pending_institute_model.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';
import 'package:popover/popover.dart';

class PendingInstituteItemWidget extends StatelessWidget {
  final PendingInstituteItem? pendingInstituteItem;
  final int index;
  const PendingInstituteItemWidget({super.key, this.pendingInstituteItem, required this.index,  });

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault, vertical: 5),
      child: ResponsiveHelper.isDesktop(context)?
      Column(children: [
          Row(spacing: Dimensions.paddingSizeSmall, children: [
            Expanded(child: Text("${pendingInstituteItem?.collectedData?.instituteName}",
              style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),)),
            Expanded(child: Text("${pendingInstituteItem?.collectedData?.instituteDomain}",
              style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),)),
            Expanded(child: Text("${pendingInstituteItem?.collectedData?.institutePhone}",
              style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),)),
            Expanded(child: Text("${pendingInstituteItem?.collectedData?.instituteEmail}",
              style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),)),
            Expanded(child: Text("${pendingInstituteItem?.collectedData?.instituteType}",
              style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),)),



              IconButton(onPressed: (){
                showPopover(context: context,
                  bodyBuilder: (context) => Padding(
                    padding: const EdgeInsets.all(8.0),
                    child: Column(spacing: Dimensions.paddingSizeSmall, crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.center,mainAxisSize: MainAxisSize.min, children: [
                      CustomButton(onTap: (){
                        Get.back();
                        Get.find<InstituteController>().approveInstituteRequest(pendingInstituteItem!.id!);
                      }, text: "approve".tr),
                      CustomButton(onTap: (){}, text: "reject".tr, borderColor: Theme.of(context).colorScheme.error,
                        buttonColor: Theme.of(context).colorScheme.error, textColor: Colors.white, ),
                    ])),
                  direction: PopoverDirection.bottom,
                  width: 200,
                  height: 120,
                  arrowHeight: 15,
                  arrowWidth: 30,
                );
              }, icon: const Icon(Icons.more_vert_rounded))
            ],
          ),
          const Padding(padding: EdgeInsets.symmetric(vertical: Dimensions.paddingSizeSmall),
            child: CustomDivider()),
        ],
      ) :
      CustomContainer(borderRadius: Dimensions.paddingSizeExtraSmall,
        child: Row(children: [
            Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                Text("${"institute".tr} : ${pendingInstituteItem?.collectedData?.instituteName}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),
                Text("${"domain".tr} : ${pendingInstituteItem?.collectedData?.instituteDomain}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),
                Text("${"email".tr} : ${pendingInstituteItem?.collectedData?.instituteEmail}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),
                Text("${"phone".tr} : ${pendingInstituteItem?.collectedData?.institutePhone}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),
                Text("${"type".tr} : ${pendingInstituteItem?.collectedData?.instituteType}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),

              ]),
            ),
            EditDeleteSection(onEdit: (){

            },
              onDelete: (){
                Get.dialog(ConfirmationDialog(
                  title: "institute",
                  content: "institute",
                  onTap: (){
                    Get.back();
                  
                  },));

            },)
          ],
        ),
      ),
    );
  }
}