import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/no_data_found.dart';
import 'package:mighty_school/common/widget/paginated_list_widget.dart';
import 'package:mighty_school/feature/institute/controller/institute_controller.dart';
import 'package:mighty_school/feature/institute/domain/models/pending_institute_model.dart';
import 'package:mighty_school/feature/institute/presentation/widgets/pending_institute_item_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class PendingInstituteListWidget extends StatefulWidget {
  final ScrollController scrollController;
  const PendingInstituteListWidget({super.key, required this.scrollController});

  @override
  State<PendingInstituteListWidget> createState() => _PendingInstituteListWidgetState();
}

class _PendingInstituteListWidgetState extends State<PendingInstituteListWidget> {
  @override
  void initState() {
    Get.find<InstituteController>().getPendingInstituteList(1);
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return GetBuilder<InstituteController>(
        builder: (instituteController) {
          PendingInstituteModel? pendingInstituteModel = instituteController.pendingInstituteModel;
          var pendingInstitute = pendingInstituteModel?.data;
          return CustomContainer(horizontalPadding: 0, color: ResponsiveHelper.isDesktop(context)? Theme.of(context).cardColor : Theme.of(context).scaffoldBackgroundColor, showShadow: false,
            child: Padding(
              padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
              child: Column(children: [
                if(ResponsiveHelper.isDesktop(context))...[

                    const SizedBox(height: Dimensions.paddingSizeDefault,),
                  Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
                    Expanded(child: Text("institute".tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeLarge),)),
                    Expanded(child: Text("domain".tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeLarge),)),
                    Expanded(child: Text("phone".tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeLarge),)),
                    Expanded(child: Text("email".tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeLarge),)),
                    Expanded(child: Text("type".tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeLarge),)),

                    Text('action'.tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeLarge)),

                  ]),
                  const Padding(padding: EdgeInsets.symmetric(vertical: Dimensions.paddingSizeSmall),
                    child: CustomDivider())
                ],

                pendingInstituteModel != null? (pendingInstituteModel.data!= null && pendingInstituteModel.data!.data!.isNotEmpty)?
                PaginatedListWidget(scrollController: widget.scrollController,
                    onPaginate: (int? offset) async {
                      await instituteController.getPendingInstituteList(offset??1);
                    }, totalSize: pendingInstitute?.total??0,
                    offset: pendingInstitute?.currentPage??0,
                    itemView: Padding(
                      padding: const EdgeInsets.only(bottom: 8.0),
                      child: ListView.builder(
                          itemCount: pendingInstitute?.data?.length??0,
                          padding: EdgeInsets.zero,
                          shrinkWrap: true,
                          physics: const NeverScrollableScrollPhysics(),
                          itemBuilder: (context, index){
                            return PendingInstituteItemWidget(index: index, pendingInstituteItem: pendingInstitute?.data?[index],);
                          }),
                    )):
                Padding(padding:ThemeShadow.getPadding(),
                  child: const Center(child: NoDataFound()),
                ):
                Padding(padding: ThemeShadow.getPadding(), child: const CircularProgressIndicator()),
              ],),
            ),
          );
        }
    );
  }
}
