import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/library_management/book/controller/book_controller.dart';
import 'package:mighty_school/feature/library_management/book/domain/model/book_model.dart';
import 'package:mighty_school/feature/library_management/book/presentation/screens/create_new_book_dialog.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class BookItemWidget extends StatelessWidget {
  final BookItem? bookItem;
  final int index;
  const BookItemWidget({super.key, this.bookItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: ResponsiveHelper.isDesktop(context)?
        const EdgeInsets.fromLTRB(Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, 0):
    const EdgeInsets.symmetric(vertical : Dimensions.paddingSizeExtraSmall),
      child: ResponsiveHelper.isDesktop(context)?
      Column(children: [
          Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
            Expanded(child: Text('${bookItem?.bookName}', style: textRegular.copyWith(),)),

            EditDeleteSection(horizontal: true, onDelete: (){
              Get.dialog(ConfirmationDialog(
                title: "book",
                content: "book",
                onTap: (){
                  Get.back();
                  Get.find<BookController>().deleteBook(bookItem!.id!);
                },));

            }, onEdit: (){
              Get.dialog(CreateNewBookScreen(bookItem: bookItem));
            },)
          ],
          ),
          const CustomDivider(verticalPadding: Dimensions.paddingSizeExtraSmall,)
        ],
      ):
      CustomContainer(borderRadius: Dimensions.paddingSizeExtraSmall,

        child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Expanded(
            child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [

              Text('${bookItem?.bookName}', style: textRegular.copyWith(),),

            ],),
          ),
          EditDeleteSection(horizontal: true, onDelete: (){
            Get.dialog(ConfirmationDialog(
              title: "book",
              content: "book",
              onTap: (){
                Get.back();
               Get.find<BookController>().deleteBook(bookItem!.id!);
              },));

          }, onEdit: (){
           Get.dialog(CreateNewBookScreen(bookItem: bookItem));
          },)
        ],
        ),
      ),
    );
  }
}
