import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/common/widget/no_data_found.dart';
import 'package:mighty_school/common/widget/paginated_list_widget.dart';
import 'package:mighty_school/feature/library_management/book/controller/book_controller.dart';
import 'package:mighty_school/feature/library_management/book/presentation/screens/create_new_book_dialog.dart';
import 'package:mighty_school/feature/library_management/book/presentation/widgets/book_item_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class BookListWidget extends StatefulWidget {
  final ScrollController scrollController;
  const BookListWidget({super.key, required this.scrollController});

  @override
  State<BookListWidget> createState() => _BookListWidgetState();
}

class _BookListWidgetState extends State<BookListWidget> {
  @override
  void initState() {
    Get.find<BookController>().getBookList(1);
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return CustomContainer(color: ResponsiveHelper.isDesktop(context)? Theme.of(context).cardColor : Colors.transparent,showShadow: false,
      child: Column(children: [
        if(ResponsiveHelper.isDesktop(context))...[
          CustomTitle(title: "book", widget: SizedBox(width: 120, child: CustomButton(onTap: (){
            Get.dialog(const CreateNewBookScreen());
          }, text: "add".tr)),),
          const SizedBox(height: Dimensions.paddingSizeSmall),

          Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeSmall),
              child: Row(children: [
                Expanded(child: Text("name".tr, style: textMedium.copyWith())),
                SizedBox(width: 70,child: Text("action".tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault))),

              ])),
        ],

          GetBuilder<BookController>(
              builder: (bookController) {
                var book = bookController.bookModel?.data;
                return  bookController.bookModel != null? (bookController.bookModel!.data!= null && bookController.bookModel!.data!.data!.isNotEmpty)?
                PaginatedListWidget(scrollController: widget.scrollController,
                    onPaginate: (int? offset){
                      bookController.getBookList(offset??1);
                    }, totalSize: book?.total??0,
                    offset: book?.currentPage??0,
                    itemView: ListView.builder(
                        itemCount: book?.data?.length??0,
                        padding: EdgeInsets.zero,
                        shrinkWrap: true,
                        physics: const NeverScrollableScrollPhysics(),
                        itemBuilder: (context, index){
                          return BookItemWidget(bookItem: book?.data?[index], index: index);
                        })) :
                Padding(padding: EdgeInsets.symmetric(vertical: Get.height/2),
                  child: const Center(child: NoDataFound()),):

                Padding(padding: ThemeShadow.getPadding(),
                    child: const Center(child: CircularProgressIndicator()));
              }
          ),
        ],
      ),
    );
  }
}
