import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/common/widget/no_data_found.dart';
import 'package:mighty_school/common/widget/paginated_list_widget.dart';
import 'package:mighty_school/feature/library_management/book_category/controller/book_category_controller.dart';
import 'package:mighty_school/feature/library_management/book_category/presentation/screens/create_new_book_category_dialog.dart';
import 'package:mighty_school/feature/library_management/book_category/presentation/widgets/book_category_item_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class BookCategoriesListWidget extends StatefulWidget {
  final ScrollController scrollController;
  const BookCategoriesListWidget({super.key, required this.scrollController});

  @override
  State<BookCategoriesListWidget> createState() => _BookCategoriesListWidgetState();
}

class _BookCategoriesListWidgetState extends State<BookCategoriesListWidget> {

  @override
  void initState() {
    Get.find<BookCategoryController>().getBookCategoriesList();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return CustomContainer(color: ResponsiveHelper.isDesktop(context)? Theme.of(context).cardColor : Colors.transparent, showShadow: false,
      child: Column(children: [
        if(ResponsiveHelper.isDesktop(context))...[
          CustomTitle(title: "book_category", widget: SizedBox(width: 120, child: CustomButton(onTap: (){
            Get.dialog(const CreateNewBookCategoryScreen());
          }, text: "add".tr)),),
          const SizedBox(height: Dimensions.paddingSizeSmall),

          Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeSmall),
              child: Row(children: [
                Expanded(child: Text("name".tr, style: textMedium.copyWith())),
                SizedBox(width: 70,child: Text("action".tr, style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault))),

              ])),
        ],
          GetBuilder<BookCategoryController>(
              builder: (bookCategoryController) {
                var bookCategory = bookCategoryController.bookCategoryModel?.data;
                return  bookCategoryController.bookCategoryModel != null? (bookCategoryController.bookCategoryModel!.data!= null && bookCategoryController.bookCategoryModel!.data!.data!.isNotEmpty)?
                PaginatedListWidget(scrollController: widget.scrollController,
                    onPaginate: (int? offset){
                      bookCategoryController.getBookCategoriesList( page : offset??1);
                    }, totalSize: bookCategory?.total??0,
                    offset: bookCategory?.currentPage??0,
                    itemView: ListView.builder(
                        itemCount: bookCategory?.data?.length??0,
                        padding: EdgeInsets.zero,
                        shrinkWrap: true,
                        physics: const NeverScrollableScrollPhysics(),
                        itemBuilder: (context, index){
                          return BookCategoryItemWidget(bookCategoryItem: bookCategory?.data?[index], index: index);
                        })) :
                Padding(padding: EdgeInsets.symmetric(vertical: Get.height/2),
                  child: const Center(child: NoDataFound()),):

                Padding(padding: ThemeShadow.getPadding(),
                    child: const Center(child: CircularProgressIndicator()));
              }
          ),
        ],
      ),
    );
  }
}
