import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/library_management/book_category/controller/book_category_controller.dart';
import 'package:mighty_school/feature/library_management/book_category/domain/model/book_category_model.dart';
import 'package:mighty_school/feature/library_management/book_category/presentation/screens/create_new_book_category_dialog.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class BookCategoryItemWidget extends StatelessWidget {
  final BookCategoryItem? bookCategoryItem;
  final int index;
  const BookCategoryItemWidget({super.key, this.bookCategoryItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: ResponsiveHelper.isDesktop(context)?
    const EdgeInsets.fromLTRB(Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, 0):
    const EdgeInsets.symmetric(vertical : Dimensions.paddingSizeExtraSmall),
      child: ResponsiveHelper.isDesktop(context)?
      Column(
        children: [
          Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
            Expanded(child: Text('${bookCategoryItem?.categoryName}', style: textRegular.copyWith(),)),

            EditDeleteSection(horizontal: true, onDelete: (){
              Get.dialog(ConfirmationDialog(
                title: "book_category",
                content: "book_category",
                onTap: (){
                  Get.back();
                  Get.find<BookCategoryController>().deleteBookCategory(bookCategoryItem!.id!);
                },));

            }, onEdit: (){
              Get.dialog(CreateNewBookCategoryScreen(bookCategoryItem: bookCategoryItem));
            },)
          ],
          ),
          const CustomDivider(verticalPadding: Dimensions.paddingSizeExtraSmall)
        ],
      ):
      CustomContainer(borderRadius: Dimensions.paddingSizeExtraSmall,

        child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Expanded(
            child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [

              Text('${bookCategoryItem?.categoryName}', style: textRegular.copyWith(),),

            ],),
          ),
          EditDeleteSection(horizontal: true, onDelete: (){
            Get.dialog(ConfirmationDialog(
              title: "book_category",
              content: "book_category",
              onTap: (){
                Get.back();
               Get.find<BookCategoryController>().deleteBookCategory(bookCategoryItem!.id!);
              },));

          }, onEdit: (){
           Get.dialog(CreateNewBookCategoryScreen(bookCategoryItem: bookCategoryItem));
          },)
        ],
        ),
      ),
    );
  }
}
