import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/confirmation_dialog.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_divider.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/edit_delete_section.dart';
import 'package:mighty_school/feature/library_management/library_member/domain/model/library_member_model.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class LibraryMemberItemWidget extends StatelessWidget {
  final LibraryMemberItem? memberItem;
  final int index;
  const LibraryMemberItemWidget({super.key, this.memberItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.fromLTRB(Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, Dimensions.paddingSizeDefault, 0),
      child: ResponsiveHelper.isDesktop(context)?
      Column(children: [
          Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
            SizedBox(width: 50, child: Row(
              children: [Text('${memberItem?.user?.id}', style: textRegular.copyWith())])),
            const SizedBox(width: Dimensions.paddingSizeSmall),

            SizedBox(width: 50, child: Row(
              children: [CustomImage(radius: 123, image: memberItem?.user?.image, width: 25, height: 25)])),
            const SizedBox(width: Dimensions.paddingSizeSmall),

            Expanded(child: Text('${memberItem?.user?.name}', style: textRegular.copyWith(),)),
            const SizedBox(width: Dimensions.paddingSizeSmall),

            Expanded(child: Text('${memberItem?.memberType}', style: textRegular.copyWith(),)),
            const SizedBox(width: Dimensions.paddingSizeSmall),

          ],
          ),
          const CustomDivider(verticalPadding: Dimensions.paddingSizeExtraSmall,)
        ],
      ):
      CustomContainer(borderRadius: Dimensions.paddingSizeExtraSmall,

        child: Row(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Expanded(
            child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [

              Text('${memberItem?.user?.name}', style: textRegular.copyWith(),),

            ],),
          ),
          EditDeleteSection(horizontal: true, onDelete: (){
            Get.dialog(ConfirmationDialog(
              title: "book",
              content: "book",
              onTap: (){
                Get.back();

              },));

          }, onEdit: (){

          },)
        ],
        ),
      ),
    );
  }
}
