import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/no_data_found.dart';
import 'package:mighty_school/common/widget/paginated_list_widget.dart';
import 'package:mighty_school/feature/library_management/library_member/controller/library_member_controller.dart';
import 'package:mighty_school/feature/library_management/library_member/domain/model/library_member_model.dart';
import 'package:mighty_school/feature/library_management/library_member/presentation/widgets/library_member_item_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class LibraryMemberListWidget extends StatefulWidget {
  final ScrollController scrollController;
  const LibraryMemberListWidget({super.key, required this.scrollController});

  @override
  State<LibraryMemberListWidget> createState() => _LibraryMemberListWidgetState();
}

class _LibraryMemberListWidgetState extends State<LibraryMemberListWidget> {
  @override
  void initState() {
    Get.find<LibraryMemberController>().getMemberList(1);
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return CustomContainer(color: ResponsiveHelper.isDesktop(context)? Theme.of(context).cardColor : Colors.transparent,showShadow: false,
      child: Column(children: [
        if(ResponsiveHelper.isDesktop(context))...[


          Padding(padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeSmall),
              child: Row(children: [
                SizedBox(width: 50,child: Row(children: [Text("id".tr, style: textMedium.copyWith())])),
                const SizedBox(width: Dimensions.paddingSizeSmall),

                SizedBox(width: 50, child: Row(children: [Text("image".tr, style: textMedium.copyWith())])),
                const SizedBox(width: Dimensions.paddingSizeSmall),

                Expanded(child: Text("name".tr, style: textMedium.copyWith())),
                const SizedBox(width: Dimensions.paddingSizeSmall),

                Expanded(child: Text("type".tr, style: textMedium.copyWith())),
                const SizedBox(width: Dimensions.paddingSizeSmall),



              ])),
        ],

          GetBuilder<LibraryMemberController>(
              builder: (memberController) {
                var member = memberController.libraryMemberModel?.data;
                LibraryMemberModel? memberModel = memberController.libraryMemberModel;
                return  memberModel != null? (memberModel.data != null && memberModel.data!.data!.isNotEmpty)?
                PaginatedListWidget(scrollController: widget.scrollController,
                    onPaginate: (int? offset) async {
                      memberController.getMemberList(offset??1);
                    }, totalSize: member?.total??0,
                    offset: member?.currentPage??0,
                    itemView: ListView.builder(
                        itemCount: member?.data?.length??0,
                        padding: EdgeInsets.zero,
                        shrinkWrap: true,
                        physics: const NeverScrollableScrollPhysics(),
                        itemBuilder: (context, index){
                          return LibraryMemberItemWidget(memberItem: member?.data?[index], index: index);
                        })) :
                Padding(padding: EdgeInsets.only(top: Get.height/4),
                  child: const Center(child: NoDataFound()),):

                Padding(padding: EdgeInsets.only(top: Get.height / 4),
                    child: const Center(child: CircularProgressIndicator()));
              }
          ),
        ],
      ),
    );
  }
}
