import 'package:get/get_connect/http/src/response/response.dart';
import 'package:mighty_school/api_handle/api_client.dart';
import 'package:mighty_school/util/app_constants.dart';

class ChildrenRepository{
  final ApiClient apiClient;
  ChildrenRepository({required this.apiClient});

  Future<Response?> getChildrenList() async {
    return await apiClient.getData(AppConstants.children);
  }

  Future<Response?> setDefaultChildren(String id) async {
    return await apiClient.postData(AppConstants.setDefaultChildren, {'student_id': id});
  }

  Future<Response?> getChildrenBehaviors(int page) async {
    return await apiClient.getData("${AppConstants.childrenBehaviors}?page=$page&perPage=10");
  }

}