import 'package:get/get.dart';
import 'package:mighty_school/api_handle/api_checker.dart';
import 'package:mighty_school/feature/payroll_management/due/domain/repository/due_repository.dart';

class DueController extends GetxController implements GetxService {
  final DueRepository dueRepository;
  DueController({required this.dueRepository});

  Future<void> getDue() async {
    Response? response = await dueRepository.getDue();
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> createDue() async {
    Response? response = await dueRepository.createDue();
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> editDue() async {
    Response? response = await dueRepository.editDue();
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }

  Future<void> deleteDue() async {
    Response? response = await dueRepository.deleteDue();
    if (response?.statusCode == 200) {
      
    } else {
      ApiChecker.checkApi(response!);
    }
    update();
  }
}
  