import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_dropdown.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/feature/hrm/payroll/controller/payroll_controller.dart';

class SelectYearAndMonthWidget extends StatelessWidget {
  final Function()? onTap;
  const SelectYearAndMonthWidget({super.key, this.onTap});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<PayrollController>(
      builder: (payrollController) {
        return Row(children: [

          const CustomTitle(title: "year"),
          Padding(padding: const EdgeInsets.symmetric(vertical: 8.0),
            child: CustomDropdown(width: Get.width, title: "choose_year".tr,
              items: payrollController.yearList,
              selectedValue: payrollController.selectedYear,
              onChanged: (val){
                payrollController.setSelectedYear(val!);
              },
            ),),
          const CustomTitle(title: "month"),
          Padding(padding: const EdgeInsets.symmetric(vertical: 8.0),
            child: CustomDropdown(width: Get.width, title: "choose_month".tr,
              items: payrollController.monthList,
              selectedValue: payrollController.selectedMonth,
              onChanged: (val){
                payrollController.setSelectedMonth(val!);
              },
            ),),
        ]);
      }
    );
  }
}
