import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/staff_information/staff/domain/models/staff_model.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class StaffItemWidget extends StatelessWidget {
  final StaffItem? staffItem;
  final int index;
  const StaffItemWidget({super.key, this.staffItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: EdgeInsets.symmetric(vertical: ResponsiveHelper.isDesktop(context)? 5 : 0),
      child: ResponsiveHelper.isDesktop(context)?
      Row(spacing: Dimensions.paddingSizeSmall, children: [

        NumberingWidget(index: index),
        ClipRRect(borderRadius: BorderRadius.circular(120),
            child: CustomImage(width: Dimensions.profileWebImageSize,
                height: Dimensions.profileWebImageSize, image: staffItem?.image)),
        Expanded(child :Text("${staffItem?.name}", style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
        Expanded(child: Text(staffItem?.phone??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
        Expanded(child: Text(staffItem?.email??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
        Expanded(child: Text(staffItem?.designation??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
      ]) :
      CustomContainer(borderRadius: 6,
          child: Row(spacing: Dimensions.paddingSizeSmall, crossAxisAlignment: CrossAxisAlignment.start, children: [
          ClipRRect(borderRadius: BorderRadius.circular(120),
              child: const CustomImage(width: Dimensions.imageSizeBig, height: Dimensions.imageSizeBig, image: "")),

          Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
            Text("${staffItem?.name}, ${staffItem?.designation??''}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),
            Text("${"phone".tr} : ${staffItem?.phone??''}", style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),

          ]),
          ),
        ],
      )),
    );
  }
}