import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/layout/list_layout_widget.dart';
import 'package:mighty_school/feature/staff_information/staff/controller/staff_controller.dart';
import 'package:mighty_school/feature/staff_information/staff/presentation/widgets/staff_item.dart';
import 'package:mighty_school/helper/route_helper.dart';

class StaffListWidget extends StatelessWidget {
  final ScrollController scrollController;
  const StaffListWidget({super.key, required this.scrollController});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<StaffController>(
      initState: (val) => Get.find<StaffController>().getStaffList(1),
      builder: (staffController) {
        final staffModel = staffController.staffModel;
        final staffData = staffModel?.data;

        return GenericListSection(
          sectionTitle: "staff_information".tr,
          pathItems: ["staff_list".tr],
          addNewTitle: "add_new_staff".tr,
          onAddNewTap: () => Get.toNamed(RouteHelper.getAddNewStaffRoute()),
          headings: const ["image", "name", "phone", "email", "designation"],

          scrollController: scrollController,
          isLoading: staffModel == null,
          totalSize: staffData?.total ?? 0,
          offset: staffData?.currentPage ?? 0,
          onPaginate: (offset) async => await staffController.getStaffList(offset ?? 1),

          items: staffData?.data ?? [],
          itemBuilder: (item, index) => StaffItemWidget(
            index: index,
            staffItem: item,
          ),
        );
      },
    );
  }
}