import 'package:flutter/material.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_image.dart';
import 'package:mighty_school/common/widget/numbering_widget.dart';
import 'package:mighty_school/feature/staff_information/teacher/domain/model/teacher_model.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';
import 'package:mighty_school/util/styles.dart';

class TeacherItemWidget extends StatelessWidget {
  final TeacherItem? teacherItem;
  final int index;
  const TeacherItemWidget({super.key, this.teacherItem, required this.index});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.symmetric(vertical: 5),
      child: ResponsiveHelper.isDesktop(context)?
      Row(spacing: Dimensions.paddingSizeSmall,children: [
        NumberingWidget(index: index),
        ClipRRect(borderRadius: BorderRadius.circular(120),
            child:  CustomImage(width: Dimensions.profileWebImageSize,
                height: Dimensions.profileWebImageSize, image: teacherItem?.image)),

        Expanded(child: Text("${teacherItem?.name}", style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
        Expanded(child: Text(teacherItem?.phone??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
        Expanded(child: Text(teacherItem?.email??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),
        Expanded(child: Text(teacherItem?.designation??'', style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),)),

      ],):
      CustomContainer(borderRadius: Dimensions.paddingSizeExtraSmall,
        child: Row(crossAxisAlignment: CrossAxisAlignment.start,spacing: Dimensions.paddingSizeSmall,
          children: [
            ClipRRect(borderRadius: BorderRadius.circular(120),
                child:  CustomImage(width: Dimensions.imageSizeBig,
                    height: Dimensions.imageSizeBig, image: teacherItem?.image)),

            Expanded(child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
              Text("${teacherItem?.name} : ${teacherItem?.designation??''}", style: textMedium.copyWith(fontSize: Dimensions.fontSizeDefault),),
              Text(" ${teacherItem?.phone??''}", style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),
              Text(" ${teacherItem?.phone??''}", style: textRegular.copyWith(fontSize: Dimensions.fontSizeSmall),),

            ]),
            ),

          ],
        ),
      ),
    );
  }
}