import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:mighty_school/common/widget/custom_button.dart';
import 'package:mighty_school/common/widget/custom_contaner.dart';
import 'package:mighty_school/common/widget/custom_title.dart';
import 'package:mighty_school/common/widget/no_data_found.dart';
import 'package:mighty_school/common/widget/paginated_list_widget.dart';
import 'package:mighty_school/feature/zoom_class/domain/model/zoom_class_model.dart';
import 'package:mighty_school/feature/zoom_class/logic/zoom_class_controller.dart';
import 'package:mighty_school/feature/zoom_class/presentation/widgets/zoom_item_widget.dart';
import 'package:mighty_school/helper/responsive_helper.dart';
import 'package:mighty_school/util/dimensions.dart';

class ZoomClassWidget extends StatelessWidget {
  final ScrollController scrollController;
  const ZoomClassWidget({super.key, required this.scrollController});

  @override
  Widget build(BuildContext context) {
    return Padding(padding: const EdgeInsets.all(Dimensions.paddingSizeDefault),
      child: CustomContainer(
        child: Column(children: [
          if(ResponsiveHelper.isDesktop(context))...[

            CustomTitle(title: "live_class_list", widget: SizedBox(width: 120, child: CustomButton(onTap: (){

            }, text: "add".tr)),),

            Padding(padding: const EdgeInsets.symmetric(vertical: Dimensions.paddingSizeSmall),
              child: Row(spacing: Dimensions.paddingSizeSmall, children: [
                Expanded(child: Text("topic".tr)),
                Expanded(child: Text("agenda".tr)),
                Expanded(child: Text("start_time".tr)),
                Expanded(child: Text("duration".tr)),
                Expanded(child: Text("join_url".tr)),
                Expanded(child: Text("start_url".tr)),
                Text("action".tr),
              ],),
            ),
          ],

          GetBuilder<ZoomClassController>(
            initState: (val) => Get.find<ZoomClassController>().getZoomClass(1),
              builder: (zoomClassController) {
                ZoomModel? zoomModel = zoomClassController.zoomModel;
                var zoomClass = zoomModel?.data;
                return zoomModel != null? (zoomModel.data!= null && zoomModel.data!.data!.isNotEmpty)?
                PaginatedListWidget(scrollController: scrollController,
                    onPaginate: (int? offset) async {
                      await zoomClassController.getZoomClass(offset??1);
                    }, totalSize: zoomClass?.total??0,
                    offset: zoomClass?.currentPage??0,
                    itemView: ListView.builder(
                        itemCount: zoomClass?.data?.length??0,
                        padding: EdgeInsets.zero,
                        shrinkWrap: true,
                        physics: const NeverScrollableScrollPhysics(),
                        itemBuilder: (context, index){
                          return ZoomItemWidget(index: index,
                            zoomItem: zoomClass?.data?[index],);
                        })):
                Padding(padding: EdgeInsets.only(top: Get.height/8),
                  child: const Center(child: NoDataFound()),
                ):  Center(child: Padding(padding: EdgeInsets.only(top: Get.height/3),
                    child: const CircularProgressIndicator()));
              }
          ),

        ]),
      ),
    );
  }
}
