import 'package:flutter/cupertino.dart';


class ResponsiveHelper extends StatelessWidget {
  final Widget mobile;
  final Widget? tablet;
  final Widget desktop;

  const ResponsiveHelper({
    super.key,
    required this.mobile,
    this.tablet,
    required this.desktop,
  });


  static bool isMobile(BuildContext context) =>
      MediaQuery.of(context).size.width < 850;

  static bool isTablet(BuildContext context) =>
      MediaQuery.of(context).size.width < 1100 &&
          MediaQuery.of(context).size.width >= 850;

  static bool isDesktop(BuildContext context) =>
      MediaQuery.of(context).size.width >= 1000;

  @override
  Widget build(BuildContext context) {
    final Size size = MediaQuery.of(context).size;
    if (size.width >= 1000) {
      return desktop;
    }
    else if (size.width >= 800 && tablet != null) {
      return tablet!;
    }
    else {
      return mobile;
    }
  }
}